_G.LockeSimulator = _G.LockeSimulator or {}

local init = PlayerCamera.init
function PlayerCamera:init(unit)
	init(self, unit)
	self._tp_camera_object = World:create_camera()
	self._tp_camera_object:set_near_range(3)
	self._tp_camera_object:set_far_range(250000)
	self._tp_camera_object:set_fov(75)
	self._tp_camera_object:link(self._camera_object)
	
	local cam_rot = self._camera_object:rotation()
	local cam_rot_x, cam_rot_y, cam_rot_z, x, y, z = 0, -60, 60, 0, 0, 100
	if LockeSimulator and LockeSimulator.settings and LockeSimulator.settings.fov_camer then
		local fov_camer = LockeSimulator.settings.fov_camer
		cam_rot_x, cam_rot_y, cam_rot_z, x, y, z = fov_camer.cam_rot_x, fov_camer.cam_rot_y, fov_camer.cam_rot_z , fov_camer.x, fov_camer.y, fov_camer.z
	end
	self._tp_camera_object:set_position(self._camera_object:position() + (cam_rot:x() * cam_rot_x) + (cam_rot:y() * cam_rot_y) + (cam_rot:z() * cam_rot_z) + Vector3(x, y, z))
	
	self._vp:set_camera(self._tp_camera_object)
	
	LockeSimulator.CAMERA = self
end
function PlayerCamera:set_FOV(fov_value)
	self._camera_object:set_fov(fov_value)
	self._tp_camera_object:set_fov(fov_value)
end
local set_position = PlayerCamera.set_position
function PlayerCamera:set_position(pos)
	if managers.player.locke:is_ragdoll() then
		pos = managers.player.locke:get_body_position()
	end
	set_position(self, pos)
end
local set_rotation = PlayerCamera.set_rotation
function PlayerCamera:set_rotation(rot)
	set_rotation(self, rot)
	managers.player.locke:set_rotation(rot)
end